/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class DominateModifier
extends Modifier
implements DisplayNameModifierHook,
MeleeDamageModifierHook,
ProjectileHitModifierHook {
    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            if (modifier.getLevel() == 1) {
                return 0.25f * target.m_21223_() + damage;
            }
            if (modifier.getLevel() >= 2) {
                return 0.4f * target.m_21223_() + damage;
            }
        }
        return damage;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.DISPLAY_NAME, ModifierHooks.MELEE_DAMAGE, ModifierHooks.PROJECTILE_HIT);
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            if (target != null) {
                int level = modifier.getLevel();
                if (level == 1) {
                    arrow.m_36781_(arrow.m_36789_() + 0.25 * (double)target.m_21223_());
                }
                if (level >= 2) {
                    arrow.m_36781_(arrow.m_36789_() + 0.4 * (double)target.m_21223_());
                }
            }
        }
        return false;
    }

    public Component getDisplayName(IToolStackView tool, ModifierEntry modifier, Component name) {
        if (modifier.getLevel() >= 2) {
            return this.getDisplayName(2);
        }
        return this.getDisplayName(modifier.getLevel());
    }
}

